--> Pralable :
/*
USE master;
GO

CREATE DATABASE DB_LOCK;
GO

USE DB_LOCK;
GO
*/
CREATE TABLE dbo.T_PERSONNE_PRS
(PRS_ID            INT IDENTITY PRIMARY KEY,
 PRS_ROW_VERSION   ROWVERSION NOT NULL,
 PRS_NOM           CHAR(32) NOT NULL,
 PRS_PRENOM        VARCHAR(25));
GO

CREATE PROCEDURE dbo.P_U_PERSONNE
   @PRS_ID INT,
   @PRS_NOM CHAR(32),
   @PRS_PRENOM VARCHAR(25)
AS

-- Variable de stockage de la version de ligne
DECLARE @VERSION ROWVERSION;

-- Dmarre une transaction explicite
BEGIN TRANSACTION;

-- Capture la valeur de la version de ligne
SELECT @VERSION = PRS_ROW_VERSION
FROM   dbo.T_PERSONNE_PRS
WHERE  PRS_ID = @PRS_ID;

-- Mise  jour finale versionne
UPDATE dbo.T_PERSONNE_PRS
   SET PRS_NOM = @PRS_NOM,
       PRS_PRENOM = @PRS_PRENOM
WHERE  PRS_ID = @PRS_ID
  AND  PRS_ROW_VERSION = @VERSION;

-- Si aucune ligne impacte, annule la transaction
IF @@ROWCOUNT = 0
BEGIN
   ROLLBACK;
   RAISERROR('Mise  jour impossible. Les donnes ont volues entre-temps.', 16, 1);
RETURN;
END;

-- Valide la transaction
COMMIT;
GO